/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8371;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8371.CodeLevel8371;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxInfo {
    private static String bundleName = "ibm.nways.jdm8371.GeneralResources";
    private static ResourceBundle myBundle = ResourceBundle.getBundle(bundleName);
    protected static final String PropertiesFile = "properties/Jdm8371.txt";
    public static final String PROPNAME = "BoxInfo.jdm8371.nways.ibm";
    public static final String serPath = "ibm.nways.jdm8371.WCDefault";
    public static final int RASID = 19;
    public static final int RASSUB = 24;
    public static final int TIMEOUT_REPEAT = 1;
    public static final int MAX_NUM_OF_MOD_PORTS = 32;
    public static final int CHASSIS = 0;
    public static final int NOT_PRESENT = 254;
    public static final int NOT_RECOGNIZED = 255;
    private static final int SUCCESSFUL = 0;
    private static final int FAILED = 1;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    OIDInfo oidInfo = new OIDInfo();
    UFCInfo ufcInfo = new UFCInfo();
    CodeLevel8371 codeLevel = new CodeLevel8371();
    private GenModel deviceModel;
    private GenModel portModel;
    private GenModel codeModel;
    private GenModel systemModel;
    private GenModel UFCModel;
    private GenModel interfaceModel;
    private JdmBrowser deviceBrowser;
    private int deviceStatus;
    private int retrievalStatus;
    private GraphicPanel deviceGraphic;
    private OID deviceSysOID;
    private Vector ufcVector;
    private int NumOfUFCs;
    private int version;
    private int release;
    private int mod;
    private int ptf;
    private int agentVersion;
    private boolean isApplication;
    private static boolean is8375;
    GraphicPanel graphicPanel;
    GraphicContainer grContainer;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        ModelInfo modelInfo = null;
        Serializable serializable = null;
        String string = "BoxInfo";
        int n = 0;
        if (RAS.isEnabled(19, 24)) {
            RAS.enter(19, 24, this, string);
        }
        this.version = 0;
        this.release = 0;
        this.mod = 0;
        this.ptf = 0;
        this.deviceBrowser = jdmBrowser;
        this.deviceModel = genModel;
        myBundle = ResourceBundle.getBundle(bundleName);
        try {
            while (n < 1 && (serializable == null || serializable instanceof Timeout)) {
                modelInfo = this.deviceModel.getInfo("Initial");
                serializable = modelInfo.get("Initial.SysObjectID");
                ++n;
                if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                    if (!RAS.isEnabled(19, 24)) continue;
                    RAS.trace(19, 24, this, string, "timeout - try again");
                    continue;
                }
                this.deviceSysOID = new OID(serializable.toString());
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "OID = " + this.deviceSysOID);
                }
                if (this.oidInfo.containsKey(this.deviceSysOID)) {
                    if (this.oidInfo.getModel(this.deviceSysOID).startsWith("8375")) {
                        if (RAS.isEnabled(19, 24)) {
                            RAS.trace(19, 24, this, string, "Found a Sirius Box");
                        }
                        is8375 = true;
                    }
                    this.deviceStatus = 1;
                    serializable = modelInfo.get("Initial.SysDescr");
                    if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) continue;
                    String string2 = serializable.toString();
                    this.retrievalStatus = this.getNecessaryModels();
                    if (this.retrievalStatus == 0 && this.getCode()) {
                        if (RAS.isEnabled(19, 24)) {
                            RAS.trace(19, 24, this, string, "Using software VPD for code level");
                        }
                        this.codeLevel = new CodeLevel8371(this.version, this.release, this.mod, this.ptf);
                        continue;
                    }
                    if (RAS.isEnabled(19, 24)) {
                        RAS.trace(19, 24, this, string, "Using description = " + string2);
                    }
                    this.codeLevel = new CodeLevel8371(string2);
                    continue;
                }
                this.deviceStatus = 3;
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "Wrong device. SysOID = " + this.deviceSysOID);
                }
                new WrongSysOidMsg(this.deviceBrowser.getFrame(), myBundle.getString("deviceName"));
            }
            if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                this.deviceStatus = 2;
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "Device not responding - " + serializable.toString());
                }
                new BoxDownMsg(jdmBrowser.getFrame(), myBundle.getString("deviceName"));
            }
        }
        catch (Exception exception) {
            this.deviceStatus = 4;
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string, "Error getting initial SysOID data");
            }
            RAS.logException(19, 24, this, string, exception);
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.exit(19, 24, this, string);
        }
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public CodeLevel8371 getCodeLevel() {
        return this.codeLevel;
    }

    public boolean is8375() {
        return is8375;
    }

    public GraphicPanel getDeviceGraphic() {
        String string = "getDeviceGraphic";
        if (RAS.isEnabled(19, 24)) {
            RAS.enter(19, 24, this, string);
        }
        if (this.deviceStatus == 1 && this.retrievalStatus == 0) {
            StringTokenizer stringTokenizer;
            Properties properties;
            Object object;
            if (this.deviceGraphic != null) {
                return this.deviceGraphic;
            }
            try {
                object = new URL(this.deviceBrowser.getDocumentBase(), PropertiesFile);
                properties = new Properties();
                properties.load(((URL)object).openStream());
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "Error getting properties: " + exception.getMessage());
                }
                properties = null;
                RAS.logException(19, 24, this, string, exception);
            }
            JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
            if (properties != null) {
                String string2;
                String string3;
                if (this.oidInfo.getImage(this.deviceSysOID).substring(4).startsWith("box")) {
                    string3 = "box.layout.scheme";
                    string2 = "box.layout.fractions";
                } else {
                    string3 = "blade.layout.scheme";
                    string2 = "blade.layout.fractions";
                }
                int n = new Integer((String)((Hashtable)properties).get(string3));
                jdmLayout.setScheme(n);
                object = (String)((Hashtable)properties).get(string2);
                stringTokenizer = new StringTokenizer((String)object);
                float[] fArray = new float[stringTokenizer.countTokens()];
                boolean bl = true;
                int n2 = 0;
                while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    try {
                        fArray[n2] = Float.valueOf(string4).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (RAS.isEnabled(19, 24)) {
                            RAS.trace(19, 24, this, string, "Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                        }
                        bl = false;
                    }
                    ++n2;
                }
                if (bl) {
                    jdmLayout.setFracts(fArray);
                }
            } else {
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "Could not retrieve properties for jdm8371. Using deafault layout.");
                }
                jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
                jdmLayout.setScheme(this.oidInfo.getScheme(this.deviceSysOID));
            }
            this.grContainer = new GraphicContainer();
            if (is8375) {
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "No information to construct the device graphic for the 8375 is available.");
                }
                object = new Label(myBundle.getString("GraphicNotAvailable"), 1);
                ((Component)object).setLocation(new Point(50, 50));
                ((Component)object).setFont(new Font("Arial", 1, 14));
                this.grContainer.add((Component)object);
            } else {
                object = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
                this.grContainer.add((GraphicComponent)object);
                this.getEthernetUFCInfo();
                this.NumOfUFCs = this.ufcVector.size();
                if (this.NumOfUFCs == 0) {
                    if (RAS.isEnabled(19, 24)) {
                        RAS.trace(19, 24, this, string, "This box has no feature cards installed");
                    }
                } else if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "There are " + this.NumOfUFCs + " ufc's");
                }
                if ((stringTokenizer = this.createModel(this.deviceSysOID)) != null) {
                    this.grContainer.add((GraphicContainer)stringTokenizer);
                }
            }
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)this.grContainer);
        } else {
            this.grContainer = new GraphicContainer();
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string, "No information to construct the device graphic is available.");
            }
            Label label = new Label(myBundle.getString("GraphicNotAvailable"), 1);
            label.setLocation(new Point(50, 50));
            label.setFont(new Font("Arial", 1, 14));
            this.grContainer.add(label);
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)this.grContainer);
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.exit(19, 24, this, string);
        }
        return this.graphicPanel;
    }

    private int getNecessaryModels() {
        int n = 0;
        String string = new String();
        String string2 = "getNecessaryModels";
        if (RAS.isEnabled(19, 24)) {
            RAS.enter(19, 24, this, string2);
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.trace(19, 24, this, string2, "Attempting to retrieve the following componenets : ");
            RAS.trace(19, 24, this, string2, "\t IbmccPort - System - IbmccDev - Interface - IbmccSwVPD");
        }
        try {
            string = "IbmccSwVPD";
            this.codeModel = (GenModel)this.deviceModel.getComponent(string);
            string = "IbmccPort";
            this.portModel = (GenModel)this.deviceModel.getComponent(string);
            string = "System";
            this.systemModel = (GenModel)this.deviceModel.getComponent(string);
            string = "IbmccDev";
            this.UFCModel = (GenModel)this.deviceModel.getComponent(string);
            string = "MyInterface";
            this.interfaceModel = (GenModel)this.deviceModel.getComponent(string);
        }
        catch (Exception exception) {
            n = 1;
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string2, "Trouble getting component" + string);
            }
            RAS.logException(19, 24, this, string2, exception);
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.exit(19, 24, this, string2);
        }
        return n;
    }

    public void dispose() {
        if (RAS.isEnabled(19, 24)) {
            RAS.enter(19, 24, this, "dispose");
        }
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.exit(19, 24, this, "dispose");
        }
    }

    public CookieTray createModel(OID oID) {
        Integer n;
        Serializable serializable;
        Object object;
        WidgetCookie widgetCookie;
        String string = null;
        CookieTray cookieTray = null;
        int n2 = 0;
        new Integer(-99);
        Vector<Integer> vector = new Vector<Integer>(this.NumOfUFCs);
        String string2 = new String();
        String string3 = new String("ibm.nways.jdm8371.eui.IbmccPortPanel");
        String string4 = new String("/ibm/nways/jdm8371/" + this.oidInfo.getImage(oID));
        String string5 = new String(this.oidInfo.getModel(oID));
        int n3 = this.oidInfo.getNumPorts(oID);
        Point point = new Point(-1, -1);
        String[] stringArray = new String[this.NumOfUFCs];
        String string6 = "createModel";
        if (RAS.isEnabled(19, 24)) {
            RAS.enter(19, 24, this, string6);
        }
        try {
            string2 = new String(string5.substring(5));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            ++n2;
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string6, "An exception ocurred while attempting to retrieve info");
            }
            RAS.logException(19, 24, this, string6, (Exception)stringIndexOutOfBoundsException);
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.trace(19, 24, this, string6, "Attempting to display " + string5);
        }
        try {
            cookieTray = new CookieTray(bundleName, this.oidInfo.getPosition(oID), string4, string5, this.deviceBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
        }
        catch (Exception exception) {
            ++n2;
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string6, "There was an error creating a graphic image !!!");
            }
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string6, "Call was CookieTray ( " + bundleName + ", " + string4 + ", " + string5 + ", " + this.deviceBrowser + ", " + this.systemModel + ", ibm.nways.mib2.eui.SystemPanel)");
            }
            RAS.logException(19, 24, this, string6, exception);
        }
        if (n2 > 0) {
            return cookieTray;
        }
        int n4 = 0;
        while (n4 < this.oidInfo.getNumOfExtras(oID)) {
            string = new String(String.valueOf(string2) + this.oidInfo.getExtras(oID, n4));
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string6, "Attempting to create port " + string);
            }
            try {
                widgetCookie = new WidgetCookie(string, bundleName, null, serPath, null, this.deviceBrowser, 22, string3);
                cookieTray.AddWidget(widgetCookie);
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string6, "There was an error creating a graphic image !!!");
                }
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string6, "When attempted to create widget cookie " + string);
                }
                RAS.logException(19, 24, this, string6, exception);
            }
            ++n4;
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.trace(19, 24, this, string6, "Created extra ports successfully");
        }
        int n5 = 0;
        while (n5 < this.NumOfUFCs) {
            Integer n6;
            int n7 = (Integer)((Hashtable)this.ufcVector.elementAt(n5)).get("SlotNumber");
            if (n7 != 0 && (n6 = (Integer)((Hashtable)this.ufcVector.elementAt(n5)).get("UFCType")) != 254 && n6 != 255) {
                if (n7 == 1 + this.oidInfo.getNumSlots(oID) || n7 >= 9) {
                    if (RAS.isEnabled(19, 24)) {
                        RAS.trace(19, 24, this, string6, "This is an internal UFC");
                    }
                } else {
                    String string7 = this.ufcInfo.getName(n6);
                    if (RAS.isEnabled(19, 24)) {
                        RAS.trace(19, 24, this, string6, "Retrieving " + string7);
                    }
                    String string8 = this.ufcInfo.getImage(n6, this.oidInfo.getOrientation(oID));
                    object = new String("/ibm/nways/gifs/24_scale/" + string8);
                    int n8 = 0;
                    serializable = new Point(this.oidInfo.getSlotCoords(oID, n7));
                    if (!((Point)serializable).equals(point)) {
                        try {
                            n = new CookieTray(bundleName, (Point)serializable, (String)object, string7, this.deviceBrowser, this.UFCModel, "ibm.nways.jdm8371.eui.IbmccDevPanel");
                            while ((n8 = n7 - vector.size()) > 0) {
                                vector.addElement(null);
                            }
                            vector.addElement(n);
                            stringArray[n7] = string7;
                        }
                        catch (Exception exception) {
                            ++n2;
                            if (RAS.isEnabled(19, 24)) {
                                RAS.trace(19, 24, this, string6, "There was an error creating the graphic for a UFC !!!");
                                RAS.trace(19, 24, this, string6, "When attempted to create cookie tray " + string7);
                            }
                            RAS.logException(19, 24, this, string6, exception);
                        }
                    } else if (RAS.isEnabled(19, 24)) {
                        RAS.trace(19, 24, this, string6, "Error , there is no slot number " + n7 + " in this box");
                    }
                }
            }
            ++n5;
        }
        ModelInfo modelInfo = null;
        boolean bl = true;
        int n9 = 0;
        while (n9 < 1 && bl) {
            Vector vector2;
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string6, "Retrieving the port information, attempt = " + n9);
            }
            try {
                vector2 = this.portModel.getRestOfInfo("Graphics", "default", modelInfo, null);
                int n10 = 1;
                while (n10 <= vector2.size()) {
                    Serializable serializable2;
                    Serializable serializable3;
                    object = (ModelInfo)vector2.elementAt(n10 - 1);
                    Integer n11 = null;
                    serializable = null;
                    n = null;
                    Integer n12 = null;
                    boolean bl2 = false;
                    bl = false;
                    if (((ModelInfo)object).timeoutDetected) {
                        bl = true;
                        if (RAS.isEnabled(19, 24)) {
                            RAS.trace(19, 24, this, string6, "TimeOUTS !! while adding ports ...");
                        }
                        if (n10 > 1) {
                            --n9;
                        }
                        break;
                    }
                    Serializable serializable4 = ((ModelInfo)object).get("Index.IbmccPortNum");
                    if (serializable4 instanceof Integer) {
                        n11 = (Integer)serializable4;
                        serializable3 = ((ModelInfo)object).get("Index.IbmccSlotNum");
                        if (serializable3 instanceof Integer) {
                            serializable = (Integer)serializable3;
                            serializable2 = ((ModelInfo)object).get("Graphics.IbmccPortMediaType");
                            if (serializable2 instanceof Integer) {
                                n = (Integer)serializable2;
                                Serializable serializable5 = ((ModelInfo)object).get("Graphics.IbmccPortBaseIfIndex");
                                if (serializable5 instanceof Integer) {
                                    n12 = (Integer)serializable5;
                                } else {
                                    bl2 = true;
                                }
                            } else {
                                bl2 = true;
                            }
                        } else {
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        bl = true;
                        if (RAS.isEnabled(19, 24)) {
                            RAS.trace(19, 24, this, string6, "Bad data !! while adding ports ...");
                        }
                        if (n10 > 1) {
                            --n9;
                        }
                        break;
                    }
                    modelInfo = object;
                    serializable3 = new ModelInfo();
                    serializable2 = new ModelInfo();
                    if ((Integer)serializable != 1 + this.oidInfo.getNumSlots(oID)) {
                        String string9;
                        boolean bl3 = false;
                        ((ModelInfo)serializable3).add("Index.IbmccPortNum", n11);
                        ((ModelInfo)serializable3).add("Index.IbmccSlotNum", serializable);
                        ((ModelInfo)serializable2).add("Index.IfIndex", n12);
                        if (n11 <= n3 && (Integer)serializable == 0) {
                            string = new String(String.valueOf(string2) + "Port" + n10);
                            try {
                                widgetCookie = new WidgetCookie(string, bundleName, (ModelInfo)serializable2, serPath, this.interfaceModel, this.deviceBrowser, 18);
                                cookieTray.AddWidget(widgetCookie);
                                string9 = widgetCookie.GetFlyover().getTranslation();
                                widgetCookie.GetImage().setFlyOver(new GraphicFlyOver(String.valueOf(string9) + serializable));
                                widgetCookie.SetAction(this.portModel, (ModelInfo)serializable3, string3);
                            }
                            catch (Exception exception) {
                                ++n2;
                                if (RAS.isEnabled(19, 24)) {
                                    RAS.trace(19, 24, this, string6, "Error: There was an exception");
                                }
                                if (RAS.isEnabled(19, 24)) {
                                    RAS.trace(19, 24, this, string6, "Error: When attempted to create widget cookie = " + string);
                                }
                                RAS.logException(19, 24, this, string6, exception);
                            }
                        } else {
                            switch (n) {
                                case 2: {
                                    if (stringArray[(Integer)serializable].equals("100 Mbps FX Fast Ethernet")) {
                                        string = new String("FASTETHERFXPort" + n11);
                                        bl3 = true;
                                        break;
                                    }
                                    string = new String("155ATMPort" + n11);
                                    if (!string2.startsWith("BOX")) break;
                                    bl3 = true;
                                    break;
                                }
                                case 3: {
                                    bl3 = true;
                                    string = new String("FASTETHERPort" + n11);
                                    break;
                                }
                                default: {
                                    string = "unknown";
                                }
                            }
                            if (bl3) {
                                string = this.oidInfo.getOrientation(oID).equals("HORIZONTAL") ? new String("h" + string) : new String("v" + string);
                                try {
                                    widgetCookie = new WidgetCookie(string, bundleName, (ModelInfo)serializable2, serPath, this.interfaceModel, this.deviceBrowser, 18);
                                    string9 = widgetCookie.GetFlyover().getTranslation();
                                    widgetCookie.GetImage().setFlyOver(new GraphicFlyOver(String.valueOf(string9) + serializable));
                                    widgetCookie.SetAction(this.portModel, (ModelInfo)serializable3, string3);
                                    ((CookieTray)vector.elementAt((Integer)serializable)).AddWidget(widgetCookie);
                                }
                                catch (Exception exception) {
                                    if (RAS.isEnabled(19, 24)) {
                                        RAS.trace(19, 24, this, string6, "Got an exception when creating a port ");
                                    }
                                    if (RAS.isEnabled(19, 24)) {
                                        RAS.trace(19, 24, this, string6, "while attampting to create " + string);
                                    }
                                    RAS.logException(19, 24, this, string6, exception);
                                }
                            }
                        }
                    }
                    ++n10;
                }
            }
            catch (Exception exception) {
                vector2 = new Vector();
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string6, "Trouble getting ports model");
                }
                RAS.logException(19, 24, this, string6, exception);
            }
            ++n9;
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.trace(19, 24, this, string6, "Finished retrieving the port information successfully");
        }
        int n13 = 0;
        while (n13 < vector.size()) {
            if (vector.elementAt(n13) != null) {
                cookieTray.add((GraphicContainer)((CookieTray)vector.elementAt(n13)));
            }
            ++n13;
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.exit(19, 24, this, string6);
        }
        return cookieTray;
    }

    public void getEthernetUFCInfo() {
        this.ufcVector = new Vector();
        Vector vector = null;
        Hashtable<String, Integer> hashtable = null;
        ModelInfo modelInfo = null;
        boolean bl = true;
        String string = "getEthernetUFCInfo";
        if (RAS.isEnabled(19, 24)) {
            RAS.enter(19, 24, this, string);
        }
        try {
            int n = 0;
            while (n < 1 && bl) {
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "Getting the UFC information, attempt = " + n);
                }
                vector = this.UFCModel.getRestOfInfo("Panel", "default", modelInfo, null);
                bl = false;
                int n2 = 0;
                while (n2 < vector.size()) {
                    ModelInfo modelInfo2 = (ModelInfo)vector.elementAt(n2);
                    if (modelInfo2.timeoutDetected) {
                        if (RAS.isEnabled(19, 24)) {
                            RAS.trace(19, 24, this, string, "TimeOUTS !!!! retrieved modules in this attempt = " + n2);
                        }
                        if (n2 > 0) {
                            --n;
                        }
                        bl = true;
                        break;
                    }
                    hashtable = new Hashtable<String, Integer>();
                    Serializable serializable = modelInfo2.get("Index.IbmccSlotNum");
                    Serializable serializable2 = modelInfo2.get("Panel.IbmccDevSlotDeviceType");
                    if (serializable instanceof Integer) {
                        hashtable.put("SlotNumber", (Integer)serializable);
                        if (serializable2 instanceof Integer) {
                            hashtable.put("UFCType", (Integer)serializable2);
                        } else {
                            hashtable.put("UFCType", new Integer(255));
                        }
                        if ((Integer)serializable == 0 && this.oidInfo.getModel(this.deviceSysOID).equals("8371-BLADE") && (Integer)serializable2 == 2) {
                            if (RAS.isEnabled(19, 24)) {
                                RAS.trace(19, 24, this, string, "This is a Vega blade with fiber ports");
                            }
                            this.deviceSysOID = new OID("1.3.6.1.4.1.2.6.118.6.9");
                        }
                    }
                    this.ufcVector.addElement(hashtable);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 24)) {
                RAS.trace(19, 24, this, string, "Exception getting IbmccDev");
            }
            RAS.logException(19, 24, this, string, exception);
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.exit(19, 24, this, string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getCode() {
        Vector vector = null;
        boolean bl = true;
        String string = "getCode";
        if (RAS.isEnabled(19, 24)) {
            RAS.enter(19, 24, this, string);
        }
        if (this.codeModel != null) {
            try {
                int n = 0;
                while (n < 1 && bl) {
                    vector = this.codeModel.getRestOfInfo("Panel", "default", null, null);
                    ModelInfo modelInfo = (ModelInfo)vector.elementAt(0);
                    if (!modelInfo.timeoutDetected) {
                        Serializable serializable = modelInfo.get("Panel.IbmccSoftwareVersionNum");
                        Serializable serializable2 = modelInfo.get("Panel.IbmccSoftwareReleaseNum");
                        Serializable serializable3 = modelInfo.get("Panel.IbmccSoftwareModLevelNum");
                        Serializable serializable4 = modelInfo.get("Panel.IbmccSoftwarePtfNum");
                        if (serializable instanceof Integer && serializable2 instanceof Integer && serializable3 instanceof Integer && serializable4 instanceof Integer) {
                            bl = false;
                            this.version = (Integer)serializable;
                            this.release = (Integer)serializable2;
                            this.mod = (Integer)serializable3;
                            this.ptf = (Integer)serializable4;
                        } else if (n == 0 && RAS.isEnabled(19, 24)) {
                            RAS.trace(19, 24, this, string, "Warning: Could not read the code level from this box !!!");
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 24)) {
                    RAS.trace(19, 24, this, string, "Exception getting model info from IbmccSwVPD");
                }
                RAS.logException(19, 24, this, string, exception);
            }
        } else if (RAS.isEnabled(19, 24)) {
            RAS.trace(19, 24, this, string, "Warning: code model is NULL !!");
        }
        if (RAS.isEnabled(19, 24)) {
            RAS.exit(19, 24, this, string);
        }
        return !bl;
    }

    private class OIDTable
    extends Hashtable {
        public void create(OID oID) {
            try {
                this.put(oID, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getHash(OID oID) {
            return (Hashtable)this.get(oID);
        }

        OIDTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class OIDInfo {
        OIDTable oidTable;

        public OIDInfo() {
            BoxInfo.this = BoxInfo.this;
            this.oidTable = new OIDTable();
            OID oID = new OID("1.3.6.1.4.1.2.6.118.6.1");
            Integer n = new Integer(2);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8371-BOX");
            this.oidTable.getHash(oID).put("Image", "8371box.gif");
            this.oidTable.getHash(oID).put("Position", new Point(20, 15));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Orientation", "HORIZONTAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(46, 10));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(334, 10));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(16));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(1));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            oID = new OID("1.3.6.1.4.1.2.6.118.6.2");
            n = new Integer(1);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8371-BLADE");
            this.oidTable.getHash(oID).put("Image", "8371blade.gif");
            this.oidTable.getHash(oID).put("Position", new Point(20, 15));
            this.oidTable.getHash(oID).put("Scheme", new Integer(1));
            this.oidTable.getHash(oID).put("Orientation", "VERTICAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(33, 79));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(16));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(2));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("MDI");
            oID = new OID("1.3.6.1.4.1.2.6.118.6.3");
            n = new Integer(2);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8375-BOX");
            this.oidTable.getHash(oID).put("Image", "8371box.gif");
            this.oidTable.getHash(oID).put("Position", new Point(20, 15));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Orientation", "HORIZONTAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(46, 10));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(334, 10));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(16));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(1));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            oID = new OID("1.3.6.1.4.1.2.6.118.6.9");
            n = new Integer(1);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8371-FIBER");
            this.oidTable.getHash(oID).put("Image", "8371fiberBlade.gif");
            this.oidTable.getHash(oID).put("Position", new Point(20, 15));
            this.oidTable.getHash(oID).put("Scheme", new Integer(1));
            this.oidTable.getHash(oID).put("Orientation", "VERTICAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(33, 79));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(16));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(2));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("MDI");
        }

        public String getModel(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Model");
        }

        public String getImage(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Image");
        }

        public Point getPosition(OID oID) {
            return (Point)this.oidTable.getHash(oID).get("Position");
        }

        public int getScheme(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Scheme");
        }

        public String getOrientation(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Orientation");
        }

        public int getNumSlots(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Slots");
        }

        public int getNumPorts(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Ports");
        }

        public Point getSlotCoords(OID oID, int n) {
            if (n - 1 >= ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).size()) {
                return new Point(-1, -1);
            }
            return (Point)((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).elementAt(n - 1);
        }

        public int getNumOfExtras(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of extra stuff");
        }

        public String getExtras(OID oID, int n) {
            if (n >= ((Vector)this.oidTable.getHash(oID).get("Extras")).size()) {
                return new String();
            }
            return (String)((Vector)this.oidTable.getHash(oID).get("Extras")).elementAt(n);
        }

        public boolean containsKey(OID oID) {
            return this.oidTable.containsKey(oID);
        }
    }

    private class UFCTable
    extends Hashtable {
        public void create(Integer n) {
            try {
                this.put(n, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getProp(Integer n) {
            if (this.containsKey(n)) {
                return (Hashtable)this.get(n);
            }
            return (Hashtable)this.get(new Integer(999));
        }

        UFCTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class UFCInfo {
        UFCTable ufcTypes;

        public UFCInfo() {
            BoxInfo.this = BoxInfo.this;
            this.ufcTypes = new UFCTable();
            Integer n = new Integer(1);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "155 Mbps ATM");
            this.ufcTypes.getProp(n).put("HORIZONTAL Image", "horizontal/h155VegaATM.gif");
            this.ufcTypes.getProp(n).put("VERTICAL Image", "vertical/n155VegaATM.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(2));
            this.ufcTypes.getProp(n).put("Ports Type", "155ATM");
            n = new Integer(2);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "100 Mbps FX Fast Ethernet");
            this.ufcTypes.getProp(n).put("HORIZONTAL Image", "horizontal/hFASTETHERFX.gif");
            this.ufcTypes.getProp(n).put("VERTICAL Image", "vertical/nFASTETHERFX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(8));
            this.ufcTypes.getProp(n).put("Ports Type", "FASTETHERFX");
            n = new Integer(3);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "10/100 Mbps TX Ethernet");
            this.ufcTypes.getProp(n).put("HORIZONTAL Image", "horizontal/hFASTETHER.gif");
            this.ufcTypes.getProp(n).put("VERTICAL Image", "vertical/nFASTETHER.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(8));
            this.ufcTypes.getProp(n).put("Ports Type", "FASTETHER");
        }

        public String getName(Integer n) {
            return (String)this.ufcTypes.getProp(n).get("Name");
        }

        public String getImage(Integer n, String string) {
            String string2 = new String(String.valueOf(string) + " Image");
            return (String)this.ufcTypes.getProp(n).get(string2);
        }

        public int getNumPorts(Integer n) {
            return (Integer)this.ufcTypes.getProp(n).get("Number of ports");
        }

        public String getPortsType(Integer n) {
            return (String)this.ufcTypes.getProp(n).get("Ports Type");
        }
    }
}

